<?php
session_start();
require_once __DIR__ . '/../includes/database.php';

if (!isset($_SESSION['admin_id'])) { header('Location: login.php'); exit; }

$db = db();
$userId = (int)($_GET['id'] ?? 0);
if (!$userId) { header('Location: index.php'); exit; }

$user = $db->fetch("SELECT * FROM users WHERE id = ?", [$userId]);
if (!$user) { header('Location: index.php'); exit; }

$dailyStats = $db->fetchAll("SELECT * FROM daily_stats WHERE user_id = ? ORDER BY stat_date DESC LIMIT 30", [$userId]);
$recentActivity = $db->fetchAll("SELECT * FROM activity_logs WHERE user_id = ? ORDER BY created_at DESC LIMIT 100", [$userId]);

$concurrentLogs = [];
try {
    $concurrentLogs = $db->fetchAll("SELECT * FROM concurrent_login_logs WHERE user_id = ? ORDER BY blocked_at DESC LIMIT 50", [$userId]);
} catch (Exception $e) {}

$totals = $db->fetch("
    SELECT COALESCE(SUM(success_count),0) as success, COALESCE(SUM(skip_count),0) as skip,
           COALESCE(SUM(stay_count),0) as stay, COALESCE(SUM(no_form_count),0) as no_form,
           COALESCE(SUM(error_count),0) as error, COALESCE(SUM(total_processed),0) as total
    FROM daily_stats WHERE user_id = ?
", [$userId]) ?: [];

$allowConcurrent = isset($user['allow_concurrent']) ? $user['allow_concurrent'] : 0;
$maxConcurrent = isset($user['max_concurrent']) ? $user['max_concurrent'] : 2;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Details - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8fafc; }
        .navbar { background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%); }
        .card { border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 12px; }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark mb-4">
        <div class="container">
            <a href="index.php" class="navbar-brand"><i class="bi bi-arrow-left me-2"></i>Back to Dashboard</a>
        </div>
    </nav>

    <div class="container">
        <div class="card mb-4">
            <div class="card-body">
                <h4><?= htmlspecialchars($user['nickname'] ?: 'User #'.$user['id']) ?></h4>
                <p class="text-muted mb-1"><i class="bi bi-pc-display me-2"></i><code><?= htmlspecialchars($user['machine_id']) ?></code></p>
                <p class="text-muted mb-1"><i class="bi bi-key me-2"></i>Login Key: <code class="text-primary fw-bold"><?= htmlspecialchars($user['login_key']) ?></code></p>
                <p class="text-muted mb-1"><i class="bi bi-clock me-2"></i>Last seen: <?= $user['last_seen'] ? date('M j, Y g:i A', strtotime($user['last_seen'])) : 'Never' ?></p>
                <p class="text-muted mb-0"><i class="bi bi-people me-2"></i>Concurrent: 
                    <?php if ($allowConcurrent): ?>
                    <span class="badge bg-warning">Allow <?= $maxConcurrent ?></span>
                    <?php else: ?>
                    <span class="badge bg-danger">Block</span>
                    <?php endif; ?>
                </p>
            </div>
        </div>

        <div class="row g-4 mb-4">
            <div class="col-md-2"><div class="card p-3 text-center"><div class="fs-4 fw-bold text-success"><?= $totals['success'] ?? 0 ?></div><small>Success</small></div></div>
            <div class="col-md-2"><div class="card p-3 text-center"><div class="fs-4 fw-bold text-danger"><?= $totals['skip'] ?? 0 ?></div><small>Skip</small></div></div>
            <div class="col-md-2"><div class="card p-3 text-center"><div class="fs-4 fw-bold text-primary"><?= $totals['stay'] ?? 0 ?></div><small>Stay</small></div></div>
            <div class="col-md-2"><div class="card p-3 text-center"><div class="fs-4 fw-bold text-warning"><?= $totals['no_form'] ?? 0 ?></div><small>No Form</small></div></div>
            <div class="col-md-2"><div class="card p-3 text-center"><div class="fs-4 fw-bold text-secondary"><?= $totals['error'] ?? 0 ?></div><small>Error</small></div></div>
            <div class="col-md-2"><div class="card p-3 text-center"><div class="fs-4 fw-bold"><?= $totals['total'] ?? 0 ?></div><small>Total</small></div></div>
        </div>

        <?php if (!empty($concurrentLogs)): ?>
        <div class="card mb-4">
            <div class="card-header bg-white"><h5 class="mb-0">🔒 Concurrent Login Attempts (Last 50)</h5></div>
            <div class="table-responsive" style="max-height:300px;overflow-y:auto">
                <table class="table table-hover mb-0">
                    <thead class="bg-light sticky-top"><tr><th>Time</th><th>Original IP</th><th>Blocked IP</th><th>Status</th></tr></thead>
                    <tbody>
                        <?php foreach ($concurrentLogs as $log): ?>
                        <tr>
                            <td><small class="text-muted"><?= date('M j, g:i A', strtotime($log['blocked_at'])) ?></small></td>
                            <td><code><?= htmlspecialchars($log['original_ip']) ?></code></td>
                            <td><code><?= htmlspecialchars($log['blocked_ip']) ?></code></td>
                            <td>
                                <?php if ($log['was_allowed']): ?>
                                <span class="badge bg-success">Allowed</span>
                                <?php else: ?>
                                <span class="badge bg-danger">Blocked</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        <div class="card mb-4">
            <div class="card-header bg-white"><h5 class="mb-0">📊 Daily Stats (Last 30 Days)</h5></div>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr><th>Date</th><th class="text-center">Success</th><th class="text-center">Skip</th><th class="text-center">Stay</th><th class="text-center">No Form</th><th class="text-center">Total</th></tr>
                    </thead>
                    <tbody>
                        <?php foreach ($dailyStats as $day): ?>
                        <tr>
                            <td><?= date('M j, Y', strtotime($day['stat_date'])) ?></td>
                            <td class="text-center text-success"><?= $day['success_count'] ?></td>
                            <td class="text-center text-danger"><?= $day['skip_count'] ?></td>
                            <td class="text-center text-primary"><?= $day['stay_count'] ?></td>
                            <td class="text-center text-warning"><?= $day['no_form_count'] ?></td>
                            <td class="text-center fw-bold"><?= $day['total_processed'] ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($dailyStats)): ?>
                        <tr><td colspan="6" class="text-center text-muted py-4">No data</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card">
            <div class="card-header bg-white"><h5 class="mb-0">📋 Recent Activity (Last 100)</h5></div>
            <div class="table-responsive" style="max-height:400px;overflow-y:auto">
                <table class="table table-hover mb-0">
                    <thead class="bg-light sticky-top"><tr><th>Time</th><th>Action</th><th>Company</th><th>Website</th></tr></thead>
                    <tbody>
                        <?php foreach ($recentActivity as $a): ?>
                        <tr>
                            <td><small class="text-muted"><?= date('M j, g:i A', strtotime($a['created_at'])) ?></small></td>
                            <td><span class="badge bg-<?= $a['action_type']=='success'?'success':($a['action_type']=='skip'?'danger':($a['action_type']=='stay'?'primary':'secondary')) ?>"><?= $a['action_type'] ?></span></td>
                            <td><?= htmlspecialchars($a['company_name'] ?: '-') ?></td>
                            <td style="max-width:200px;overflow:hidden;text-overflow:ellipsis"><?= htmlspecialchars($a['website_url'] ?: '-') ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($recentActivity)): ?>
                        <tr><td colspan="4" class="text-center text-muted py-4">No activity</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
