<?php
session_start();
require_once __DIR__ . '/../includes/database.php';

if (!isset($_SESSION['admin_id'])) { header('Location: login.php'); exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = (int)($_POST['user_id'] ?? 0);
    $nickname = trim($_POST['nickname'] ?? '');
    $loginKey = strtoupper(trim($_POST['login_key'] ?? ''));
    $isActive = isset($_POST['is_active']) ? 1 : 0;
    $allowConcurrent = isset($_POST['allow_concurrent']) ? 1 : 0;
    $maxConcurrent = (int)($_POST['max_concurrent'] ?? 2);
    
    if ($maxConcurrent < 2) $maxConcurrent = 2;
    if ($maxConcurrent > 10) $maxConcurrent = 10;
    
    if ($userId && $loginKey) {
        $db = db();
        $db->update('users', [
            'nickname' => $nickname ?: null,
            'login_key' => $loginKey,
            'is_active' => $isActive,
            'allow_concurrent' => $allowConcurrent,
            'max_concurrent' => $maxConcurrent
        ], 'id = ?', [$userId]);
        
        if (!$isActive) {
            $db->query("UPDATE sessions SET is_valid = 0 WHERE user_id = ?", [$userId]);
        }
    }
}
header('Location: index.php');
