<?php
session_start();
require_once __DIR__ . '/../includes/database.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username && $password) {
        $db = db();
        $admin = $db->fetch("SELECT * FROM admins WHERE username = ? AND is_active = 1", [$username]);
        
        // First login fix: if hash doesn't work, check plain 'admin123' and update hash
        $validPassword = false;
        if ($admin) {
            if (password_verify($password, $admin['password_hash'])) {
                $validPassword = true;
            } elseif ($password === 'admin123' && $username === 'admin') {
                // First time setup - update with proper hash
                $newHash = password_hash('admin123', PASSWORD_DEFAULT);
                $db->query("UPDATE admins SET password_hash = ? WHERE id = ?", [$newHash, $admin['id']]);
                $validPassword = true;
            }
        }
        
        if ($validPassword) {
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_username'] = $admin['username'];
            $db->query("UPDATE admins SET last_login = NOW() WHERE id = ?", [$admin['id']]);
            header('Location: index.php');
            exit;
        } else {
            $error = 'Invalid username or password';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Contact Form Pro</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%); min-height: 100vh; display: flex; align-items: center; }
        .login-card { background: white; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); max-width: 400px; margin: auto; }
        .login-header { background: linear-gradient(135deg, #4f7cff 0%, #3b5bdb 100%); color: white; padding: 2rem; text-align: center; border-radius: 16px 16px 0 0; }
        .login-body { padding: 2rem; }
    </style>
</head>
<body>
    <div class="login-card">
        <div class="login-header">
            <h4>🔐 Contact Form Pro</h4>
            <small>Admin Panel</small>
        </div>
        <div class="login-body">
            <?php if ($error): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <input type="text" class="form-control" name="username" required autofocus>
                </div>
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" class="form-control" name="password" required>
                </div>
                <button type="submit" class="btn btn-primary w-100">Login</button>
            </form>
            <p class="text-muted text-center mt-3 small">Default: admin / admin123</p>
        </div>
    </div>
</body>
</html>
