<?php
session_start();
require_once __DIR__ . '/../includes/database.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$db = db();

$totalUsers = $db->fetch("SELECT COUNT(*) as c FROM users")['c'];
$activeUsers = $db->fetch("SELECT COUNT(*) as c FROM users WHERE is_active = 1")['c'];
$todayActive = $db->fetch("SELECT COUNT(DISTINCT user_id) as c FROM daily_stats WHERE stat_date = CURDATE()")['c'];

// Get concurrent blocked count
$concurrentBlocked = 0;
try {
    $result = $db->fetch("SELECT COUNT(*) as c FROM concurrent_login_logs WHERE DATE(blocked_at) = CURDATE() AND was_allowed = 0");
    $concurrentBlocked = $result['c'] ?? 0;
} catch (Exception $e) {}

$todayStats = $db->fetch("
    SELECT COALESCE(SUM(success_count),0) as success, COALESCE(SUM(skip_count),0) as skip,
           COALESCE(SUM(stay_count),0) as stay, COALESCE(SUM(no_form_count),0) as no_form,
           COALESCE(SUM(tab_opened_count),0) as tabs_opened,
           COALESCE(SUM(total_processed),0) as total
    FROM daily_stats WHERE stat_date = CURDATE()
") ?: ['success'=>0,'skip'=>0,'stay'=>0,'no_form'=>0,'tabs_opened'=>0,'total'=>0];

$monthStats = $db->fetch("
    SELECT COALESCE(SUM(success_count),0) as success, COALESCE(SUM(total_processed),0) as total,
           COALESCE(SUM(tab_opened_count),0) as tabs_opened
    FROM daily_stats WHERE MONTH(stat_date) = MONTH(CURDATE()) AND YEAR(stat_date) = YEAR(CURDATE())
") ?: ['success'=>0,'total'=>0,'tabs_opened'=>0];

$users = $db->fetchAll("
    SELECT u.*, 
        COALESCE(t.success_count,0) as today_success, COALESCE(t.total_processed,0) as today_total,
        COALESCE(t.tab_opened_count,0) as today_tabs,
        COALESCE(m.success_count,0) as month_success, COALESCE(m.total_processed,0) as month_total,
        COALESCE(a.success_count,0) as all_success, COALESCE(a.total_processed,0) as all_total
    FROM users u
    LEFT JOIN daily_stats t ON u.id = t.user_id AND t.stat_date = CURDATE()
    LEFT JOIN (SELECT user_id, SUM(success_count) as success_count, SUM(total_processed) as total_processed FROM daily_stats WHERE MONTH(stat_date)=MONTH(CURDATE()) AND YEAR(stat_date)=YEAR(CURDATE()) GROUP BY user_id) m ON u.id = m.user_id
    LEFT JOIN (SELECT user_id, SUM(success_count) as success_count, SUM(total_processed) as total_processed FROM daily_stats GROUP BY user_id) a ON u.id = a.user_id
    ORDER BY u.last_seen DESC
");

// Get blocked counts per user
$blockedCounts = [];
try {
    $blocked = $db->fetchAll("SELECT user_id, COUNT(*) as cnt FROM concurrent_login_logs WHERE was_allowed = 0 GROUP BY user_id");
    foreach ($blocked as $b) {
        $blockedCounts[$b['user_id']] = $b['cnt'];
    }
} catch (Exception $e) {}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Contact Form Pro v7.4.4.2</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f8fafc; }
        .navbar { background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%); }
        .card { border: none; box-shadow: 0 2px 10px rgba(0,0,0,0.08); border-radius: 12px; }
        .badge-active { background: #dcfce7; color: #166534; }
        .badge-inactive { background: #fee2e2; color: #991b1b; }
        .badge-concurrent { background: #fef3c7; color: #92400e; }
        .device-id { font-size: 9px; color: #64748b; }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark mb-4">
        <div class="container">
            <span class="navbar-brand">🔐 Contact Form Pro v7.4.4.2 - Admin</span>
            <div>
                <span class="text-light me-3"><?= htmlspecialchars($_SESSION['admin_username']) ?></span>
                <a href="logout.php" class="btn btn-outline-light btn-sm">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container">
        <!-- Stats -->
        <div class="row g-4 mb-4">
            <div class="col-md-2">
                <div class="card p-3 text-center">
                    <div class="fs-3 fw-bold text-primary"><?= $totalUsers ?></div>
                    <small class="text-muted">Total Users</small>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card p-3 text-center">
                    <div class="fs-3 fw-bold text-success"><?= $todayActive ?></div>
                    <small class="text-muted">Active Today</small>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card p-3 text-center">
                    <div class="fs-3 fw-bold text-info"><?= $todayStats['success'] ?></div>
                    <small class="text-muted">Today Success</small>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card p-3 text-center">
                    <div class="fs-3 fw-bold text-warning"><?= $monthStats['total'] ?></div>
                    <small class="text-muted">Month Total</small>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card p-3 text-center">
                    <div class="fs-3 fw-bold text-danger"><?= $concurrentBlocked ?></div>
                    <small class="text-muted">Blocked Today</small>
                </div>
            </div>
        </div>

        <!-- Today Summary -->
        <div class="card mb-4">
            <div class="card-header bg-white"><h5 class="mb-0">📊 Today's Summary</h5></div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col"><div class="fs-4 fw-bold text-success"><?= $todayStats['success'] ?></div><small>Success</small></div>
                    <div class="col"><div class="fs-4 fw-bold text-danger"><?= $todayStats['skip'] ?></div><small>Skip</small></div>
                    <div class="col"><div class="fs-4 fw-bold text-primary"><?= $todayStats['stay'] ?></div><small>Stay</small></div>
                    <div class="col"><div class="fs-4 fw-bold text-warning"><?= $todayStats['no_form'] ?></div><small>No Form</small></div>
                    <div class="col"><div class="fs-4 fw-bold text-info"><?= $todayStats['tabs_opened'] ?></div><small>Tabs Opened</small></div>
                    <div class="col"><div class="fs-4 fw-bold"><?= $todayStats['total'] ?></div><small>Total</small></div>
                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="card">
            <div class="card-header bg-white"><h5 class="mb-0">👥 Users</h5></div>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>User</th>
                            <th>Machine ID</th>
                            <th>Login Key</th>
                            <th>Status</th>
                            <th>Concurrent</th>
                            <th class="text-center">Today</th>
                            <th class="text-center">Month</th>
                            <th class="text-center">Total</th>
                            <th>Last Seen</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): 
                            $allowConcurrent = isset($user['allow_concurrent']) ? $user['allow_concurrent'] : 0;
                            $maxConcurrent = isset($user['max_concurrent']) ? $user['max_concurrent'] : 2;
                            $userBlocked = $blockedCounts[$user['id']] ?? 0;
                        ?>
                        <tr>
                            <td><strong><?= htmlspecialchars($user['nickname'] ?: 'User #'.$user['id']) ?></strong></td>
                            <td>
                                <code style="font-size:11px"><?= htmlspecialchars(substr($user['machine_id'],0,20)) ?>...</code>
                                <?php if (!empty($user['device_id'])): ?>
                                <br><span class="device-id">Dev: <?= htmlspecialchars(substr($user['device_id'],0,12)) ?>...</span>
                                <?php endif; ?>
                            </td>
                            <td><code class="text-primary fw-bold"><?= htmlspecialchars($user['login_key']) ?></code></td>
                            <td><span class="badge <?= $user['is_active'] ? 'badge-active' : 'badge-inactive' ?>"><?= $user['is_active'] ? 'Active' : 'Disabled' ?></span></td>
                            <td>
                                <?php if ($allowConcurrent): ?>
                                <span class="badge badge-concurrent">Allow <?= $maxConcurrent ?></span>
                                <?php else: ?>
                                <span class="badge badge-inactive">Block</span>
                                <?php endif; ?>
                                <?php if ($userBlocked > 0): ?>
                                <br><small class="text-danger"><?= $userBlocked ?> blocked</small>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <span class="text-success"><?= $user['today_success'] ?></span>/<?= $user['today_total'] ?>
                                <?php if ($user['today_tabs'] > 0): ?>
                                <br><small class="text-info"><?= $user['today_tabs'] ?> tabs</small>
                                <?php endif; ?>
                            </td>
                            <td class="text-center"><span class="text-success"><?= $user['month_success'] ?></span>/<?= $user['month_total'] ?></td>
                            <td class="text-center"><span class="text-success"><?= $user['all_success'] ?></span>/<?= $user['all_total'] ?></td>
                            <td><small class="text-muted"><?= $user['last_seen'] ? date('M j, g:i A', strtotime($user['last_seen'])) : 'Never' ?></small></td>
                            <td>
                                <button class="btn btn-sm btn-primary" onclick="editUser(<?= $user['id'] ?>,'<?= htmlspecialchars($user['nickname'] ?? '') ?>','<?= $user['login_key'] ?>',<?= $user['is_active']?'true':'false' ?>,<?= $allowConcurrent?'true':'false' ?>,<?= $maxConcurrent ?>)"><i class="bi bi-pencil"></i></button>
                                <a href="user_details.php?id=<?= $user['id'] ?>" class="btn btn-sm btn-info"><i class="bi bi-eye"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header"><h5>Edit User</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
                <form method="POST" action="update_user.php">
                    <div class="modal-body">
                        <input type="hidden" name="user_id" id="edit_id">
                        <div class="mb-3">
                            <label class="form-label">Nickname</label>
                            <input type="text" class="form-control" name="nickname" id="edit_nickname">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Login Key</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="login_key" id="edit_key" required>
                                <button type="button" class="btn btn-outline-secondary" onclick="genKey()">Generate</button>
                            </div>
                        </div>
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" name="is_active" id="edit_active" value="1">
                            <label class="form-check-label">Account Active</label>
                        </div>
                        <hr>
                        <h6 class="text-muted">Concurrent Login Settings</h6>
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" name="allow_concurrent" id="edit_concurrent" value="1" onchange="toggleMaxConcurrent()">
                            <label class="form-check-label">Allow Concurrent Logins (different IPs)</label>
                        </div>
                        <div class="mb-3" id="max_concurrent_div" style="display:none;">
                            <label class="form-label">Max Concurrent Sessions</label>
                            <input type="number" class="form-control" name="max_concurrent" id="edit_max" min="2" max="10" value="2">
                            <small class="text-muted">How many different IPs can login at same time</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function editUser(id, nickname, key, active, allowConcurrent, maxConcurrent) {
            document.getElementById('edit_id').value = id;
            document.getElementById('edit_nickname').value = nickname || '';
            document.getElementById('edit_key').value = key;
            document.getElementById('edit_active').checked = active;
            document.getElementById('edit_concurrent').checked = allowConcurrent;
            document.getElementById('edit_max').value = maxConcurrent || 2;
            toggleMaxConcurrent();
            new bootstrap.Modal(document.getElementById('editModal')).show();
        }
        function toggleMaxConcurrent() {
            document.getElementById('max_concurrent_div').style.display = 
                document.getElementById('edit_concurrent').checked ? 'block' : 'none';
        }
        function genKey() {
            const c = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
            let k = '';
            for (let i = 0; i < 12; i++) k += c[Math.floor(Math.random() * c.length)];
            document.getElementById('edit_key').value = k;
        }
    </script>
</body>
</html>
